package com.patzn.lims.res.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsServiceType;
import com.patzn.lims.res.service.ILmsServiceTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 服务类型 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-05-09
 */
@Api(description = "服务类型表")
@RestController
@RequestMapping("/v1/service_type")
public class LmsServiceTypeController extends SuperController {

    @Autowired
    private ILmsServiceTypeService lmsServiceTypeService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsServiceType>> getPage(LmsServiceType lmsServiceType) {
        return success(lmsServiceTypeService.page(getPage(), lmsServiceType));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @GetMapping("/list")
    @Login(action = Action.Skip)
    public PtResult<List<LmsServiceType>> getList(LmsServiceType lmsServiceType) {
        return success(lmsServiceTypeService.list(lmsServiceType));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsServiceType> get(@PathVariable("id") Long id) {
        return success(lmsServiceTypeService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsServiceType lmsServiceType) {
        lmsServiceType.setId(id);
        return success(lmsServiceTypeService.updateById(lmsServiceType));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsServiceType lmsServiceType) {
        return success(lmsServiceTypeService.save(lmsServiceType));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsServiceTypeService.remove( Wrappers.<LmsServiceType>query().in("id", ids)));
    }


    @PostMapping("/get_by_name")
    @Login(action = Action.Skip)
    public PtResult<LmsServiceType> getByName(@RequestParam("name") String name,
                                                @RequestParam("companyId") Long companyId){
        return success(lmsServiceTypeService.getByName(name,companyId));
    }

}
