package com.patzn.lims.res.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.toolkit.JacksonUtils;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.dto.LmsSupplierDTO;
import com.patzn.lims.res.entity.LmsSupplier;
import com.patzn.lims.res.entity.LmsSupplierDetail;
import com.patzn.lims.res.vo.LmsSupplierTypeVO;
import com.patzn.lims.res.vo.LmsSupplierVO;
import com.patzn.lims.res.service.ILmsSupplierService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 供应商表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
@Api(description = "供应商表")
@RestController
@RequestMapping("/v1/supplier")
public class LmsSupplierController extends SuperController {

    @Autowired
    private ILmsSupplierService supplierService;
    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsSupplierTypeVO>> getPage(LmsSupplierTypeVO lmsSupplier) {
        return success(supplierService.pageTypeVO(getPage(), lmsSupplier));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsSupplier>> getList(LmsSupplier lmsSupplier) {
        return success(supplierService.list(lmsSupplier));
    }

    @ApiOperation(value = "根据ids查询供应商列表", notes = "根据ids查询供应商列表")
    @PostMapping("/list_by_ids")
    public PtResult<List<LmsSupplier>> getListByIds(@RequestBody List<Long>ids) {
        return success(supplierService.getListByIds(ids));
    }



    @ApiOperation(value = "根据ids查询供应商列表", notes = "根据ids查询供应商列表")
    @PostMapping("/list_by_name")
    public PtResult<List<LmsSupplier>> getListByNames(@RequestBody List<String>names) {
        return success(supplierService.getListByNames(names));
    }

    @PostMapping("/list_no_login")
    @Login(action = Action.Skip)
    public PtResult<List<LmsSupplier>> getListNoLogin(LmsSupplier lmsSupplier){
        return success(supplierService.listNoLogin(lmsSupplier));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list/{name}")
    public PtResult<List<LmsSupplier>> getListByName(@PathVariable("name") String name) {
        return success(supplierService.listByName(name));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsSupplierVO> get(@PathVariable("id") Long id) {
        return success(supplierService.getVoById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsSupplier lmsSupplier, LmsSupplierDetail lmsSupplierDetail) {
        lmsSupplier.setId(id);
        return success(supplierService.updateById(lmsSupplier, lmsSupplierDetail));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsSupplier lmsSupplier, LmsSupplierDetail lmsSupplierDetail) {
        return success(supplierService.save(lmsSupplier, lmsSupplierDetail));
    }


    @ApiOperation(value = "根据 id 删除", notes = "根据 id 删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @DeleteMapping("/{id}")
    public PtResult<Boolean> delete(@PathVariable("id") Long id) {
        return success(supplierService.removeById(id));
    }


    @PutMapping("/page_by_classify/{classId}")
    public PtResult<Page<LmsSupplier>> getPageByClassify(@PathVariable("classId") Long classId, LmsSupplier lmsSupplier) {
        return success(supplierService.pageByClassify(getPage(), classId, lmsSupplier));
    }


    @PutMapping("/page_by_chemical/{chemicalId}")
    public PtResult<Page<LmsSupplier>> getPageByChemical(@PathVariable("chemicalId") Long chemicalId, LmsSupplier lmsSupplier) {
        return success(supplierService.pageByChemical(getPage(), chemicalId, lmsSupplier));
    }


    @ApiOperation(value = "导出供应商信息", notes = "导出供应商数据内容")
    @PostMapping("/supplier_export")
    public void exportSupplier(@RequestParam String request) {
        LmsSupplierDTO dto = JacksonUtils.readValue(request, LmsSupplierDTO.class);
        if (null != dto) {
            supplierService.exportSupplier(response, dto);
        }
    }

    @PostMapping("/env_supplier_import")
    public PtResult<Boolean> importItem(MultipartFile file) {
        return success(supplierService.importItem(file));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/supplier_name_list")
    public PtResult<List<String>> getSupplierNameList(String name) {
        return success(new ArrayList<>(supplierService.getAllSupplierByName(name)));
    }


    @ApiOperation(value = "导入", notes = "导入")
    @PostMapping("/new_env_supplier_import")
    public PtResult<Boolean> importSupplier(MultipartFile file) {
        return success(supplierService.importSupplier(file));
    }


    @ApiOperation(value = "新分页列表", notes = "新分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/newPage")
    public PtResult<Page<LmsSupplierTypeVO>> getNewPage(LmsSupplierTypeVO lmsSupplier) {
        return success(supplierService.pageSupplier(getPage(), lmsSupplier));
    }

    @ApiOperation(value = "导出万家乐供应商信息", notes = "导出万家乐供应商信息")
    @PostMapping("/supplier_export_new")
    public void exportSupplierNew(@RequestParam String request) {
        LmsSupplierDTO dto = JacksonUtils.readValue(request, LmsSupplierDTO.class);
        if (null != dto) {
            supplierService.exportSupplierWjl(response, dto);
        }
    }

    @GetMapping("/getTemp/")
    public PtResult<LmsSupplierTypeVO> getTemp() {
        return success(supplierService.getTempVO());
    }
}
