package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsSupplierType;
import com.patzn.lims.res.service.ILmsSupplierTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 供应商表 前端控制器
 * </p>
 *
 * @author hubin
 * @since 2017-12-27
 */
@Api(description = "供应商表")
@RestController
@RequestMapping("/v1/supplier_type")
public class LmsSupplierTypeController extends SuperController {

    @Autowired
    private ILmsSupplierTypeService lmsSupplierTypeService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsSupplierType>> getPage(LmsSupplierType lmsSupplierType) {
        return success(lmsSupplierTypeService.page(getPage(), lmsSupplierType));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsSupplierType>> getList(LmsSupplierType lmsSupplierType) {
        return success(lmsSupplierTypeService.list(lmsSupplierType));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsSupplierType> get(@PathVariable("id") Long id) {
        return success(lmsSupplierTypeService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsSupplierType lmsSupplierType) {

        return success(lmsSupplierTypeService.updateById(lmsSupplierType));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsSupplierType lmsSupplierType) {
        lmsSupplierType.setCtime(new Date());
        lmsSupplierType.setCompanyId(getAccount().getCompanyId());
        lmsSupplierType.setUid(getAccount().getUserId());
        return success(lmsSupplierTypeService.save(lmsSupplierType));
    }

    @ApiOperation(value = "删除供应商分类", notes = "根据id删除供应商分类")
    @DeleteMapping("/")
    public PtResult<Boolean> del(@RequestParam Long id) {
        return success(lmsSupplierTypeService.removeById(id));
    }

}
