package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsUnit;
import com.patzn.lims.res.service.ILmsUnitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 单位表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-29
 */
@Api(description = "单位表")
@RestController
@RequestMapping("/v1/unit")
public class LmsUnitController extends SuperController {

    @Autowired
    private ILmsUnitService lmsUnitService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<Page<LmsUnit>> getPage(LmsUnit lmsUnit) {
        return success(lmsUnitService.page(getPage(), lmsUnit));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsUnit>> getList(LmsUnit lmsUnit) {
        return success(lmsUnitService.list(lmsUnit));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsUnit> get(@PathVariable("id") Long id) {
        return success(lmsUnitService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsUnit lmsUnit) {
        return success(lmsUnitService.updateById(lmsUnit));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
	public PtResult<Boolean> add(LmsUnit lmsUnit) {
        return success(lmsUnitService.save(lmsUnit));
	}


    @ApiOperation(value = "根据 id 删除", notes = "根据 id 删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
	@DeleteMapping("/{id}")
	public PtResult<Boolean> delete(@PathVariable("id") Long id) {
        return success(lmsUnitService.removeById(id));
	}


    @ApiOperation(value = "导入单位", notes = "导入单位数据内容")
    @PostMapping("/import")
    public PtResult<Boolean> importUnit(MultipartFile file) {
        return success(lmsUnitService.importUnit(file));
    }
}
