package com.patzn.lims.res.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsUserGroup;
import com.patzn.lims.res.entity.LmsUserRelGroup;
import com.patzn.lims.res.vo.LmsUserGroupVO;
import com.patzn.lims.res.vo.LmsUserRelGroupVO;
import com.patzn.lims.res.service.ILmsUserGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * 用户组表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-03-28
 */
@Api(description = "用户组表")
@RestController
@RequestMapping("/v1/user_group")
public class LmsUserGroupController extends SuperController {

    @Autowired
    private ILmsUserGroupService lmsUserGroupService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsUserGroupVO>> getPage(LmsUserGroupVO lmsUserGroup) {
        return success(lmsUserGroupService.pageUserGroup(getPage(), lmsUserGroup));
    }

    @ApiOperation(value = "查询科室列表", notes = "查询科室数据列表")
    @PostMapping("/list_group")
    public PtResult<List<LmsUserGroupVO>> getListGroup(LmsUserGroup lmsUserGroup) {
        return success(lmsUserGroupService.listUserGroup(lmsUserGroup));
    }

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsUserGroup>> getList(LmsUserGroup lmsUserGroup) {
        return success(lmsUserGroupService.list(lmsUserGroup));
    }

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @Login(action= Action.Skip)
    @PostMapping("/list_no_login")
    public PtResult<List<LmsUserGroup>> getListNoLogin(LmsUserGroup lmsUserGroup) {
        return success(lmsUserGroupService.listNoLogin(lmsUserGroup));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsUserGroup> get(@PathVariable("id") Long id) {
        return success(lmsUserGroupService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsUserGroup lmsUserGroup) {
        PtAssert.fail(null==lmsUserGroup.getName(),"请填写组名");
        return success(lmsUserGroupService.updateById(lmsUserGroup));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsUserGroup lmsUserGroup) {
        PtAssert.fail(null==lmsUserGroup.getName(),"请填写组名");
        lmsUserGroup.setCtime(new Date());
        lmsUserGroup.setCompanyId(getAccount().getCompanyId());
        lmsUserGroup.setUid(getAccount().getUserId());
        lmsUserGroup.setDeleted(0);
        return success(lmsUserGroupService.save(lmsUserGroup));
    }


    @ApiOperation(value = "给用户编组添加人员", notes = "给用户编组添加一条人员数据")
    @PostMapping("/add_user_rel_group")
    public PtResult<Boolean> addUserRelGroup(@RequestParam("group_id") Long groupId,
                                               @RequestParam("userIds") Long[] userIds,
                                               @RequestParam("realNames") String[] realNames,
                                               @RequestParam("usernames") String[] usernames) {
        return success(lmsUserGroupService.saveUserRelGroup(groupId,userIds,realNames,usernames));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsUserGroupService.remove( Wrappers.<LmsUserGroup>query().in("id", ids)));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/delete_rel_user")
    public PtResult<Boolean> deleteRelUser(@RequestParam("ids") Long[] ids) {
        return success(lmsUserGroupService.deleteRelUser(ids));
    }


    @ApiOperation(value = "查询用户编组的分页列表", notes = "用户编组查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_rel_user")
    public PtResult<Page<LmsUserRelGroup>> getPageRelUser(LmsUserRelGroup lmsUserRelGroup) {
         return success(lmsUserGroupService.getPageRelUser(getPage(), lmsUserRelGroup));
    }

    @ApiOperation(value = "查询用户多个编组的分页列表", notes = "用户编组查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_rel_user_many_group")
    public PtResult<Page<LmsUserRelGroup>> getPageRelUserManyGroup(LmsUserRelGroupVO vo) {
        vo.setCompanyId(currentCompanyId());
        return success(lmsUserGroupService.getPageRelUserManyGroup(getPage(), vo));
    }


    @ApiOperation(value = "根据用户id查询组", notes = "根据用户id查询组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "uid", value = "用户id", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/get_by_uid/{uid}")
    public PtResult<Page<LmsUserGroupVO>> listGroupByUserId(@PathVariable("uid") Long uid) {
        return success(lmsUserGroupService.pageListGroupByUserId(getPage(),uid));
    }

    @ApiOperation(value = "查询所有组", notes = "查询所有组")
    @PostMapping("/get_groups")
    public PtResult<Page<LmsUserGroupVO>> listGroups(LmsUserGroupVO vo) {
        return success(lmsUserGroupService.pageListGroups(getPage(),vo));
    }

    @ApiOperation(value = "根据组名查询用户编组", notes = "根据组名查询用户编组")
    @PostMapping("/list_group_by_name_list")
    public PtResult<List<LmsUserGroup>> listGroupByNameList(@RequestBody Set<String> groupNames) {
        return success(lmsUserGroupService.listGroupByNameList(groupNames));
    }


    @PostMapping("/list_group_by_ids")
    public PtResult<List<LmsUserGroup>> listGroupByIdList(@RequestParam("ids")Collection<Long> ids){
        return success(lmsUserGroupService.listGroupByIds(ids));

    }

    @PostMapping("/get_by_user_id")
    public PtResult<List<LmsUserGroup>> getByUserId(@RequestParam("userId")Long userId){
        return success(lmsUserGroupService.getByUserId(userId));
    }


    @PostMapping("/get_no_leader_list")
    public PtResult<List<LmsUserGroup>> getNoLeaderGroup(@RequestParam("groupIds")Collection<Long> groupIds, @RequestParam("userId") Long userId){
        return success(lmsUserGroupService.getNoLeaderGroup(groupIds,userId));
    }

    @PostMapping("/get_list_id_not_in")
    public PtResult<List<LmsUserGroup>> getListIdNotIn(@RequestParam("groupIds")Collection<Long> groupIds){
        return success(lmsUserGroupService.getListIdNotIn(groupIds));
    }


    @PostMapping("/get_by_leader_user_id")
    public PtResult<List<LmsUserGroup>> getByLeaderUserId(@RequestParam("userId")Long userId){
        return success(lmsUserGroupService.getByLeaderUserId(userId));
    }
}
