package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.dto.LmsUserGroupDTO;
import com.patzn.lims.res.entity.LmsUserRelGroup;
import com.patzn.lims.res.service.ILmsUserRelGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;
import java.util.List;

/**
 * <p>
 * 用户关联组表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-03-28
 */
@Api(description = "用户关联组表")
@RestController
@RequestMapping("/v1/user_rel_group")
public class LmsUserRelGroupController extends SuperController {

    @Autowired
    private ILmsUserRelGroupService lmsUserRelGroupService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsUserRelGroup>> getPage(LmsUserRelGroup lmsUserRelGroup) {
        return success(lmsUserRelGroupService.page(getPage(), lmsUserRelGroup));
    }


    @ApiOperation(value = "用户编组人员分页列表", notes = "用户编组人员分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_user")
    public PtResult<Page<LmsUserRelGroup>> getPageUser(LmsUserRelGroup lmsUserRelGroup) {
        return success(lmsUserRelGroupService.page(getPage(), lmsUserRelGroup));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsUserRelGroup> get(@PathVariable("id") Long id) {
        return success(lmsUserRelGroupService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsUserRelGroup lmsUserRelGroup) {
        return success(lmsUserRelGroupService.updateById(lmsUserRelGroup));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true, paramType = "path", dataType = "long"),
            @ApiImplicitParam(name = "groupId", value = "用户组id", required = true, paramType = "path", dataType = "long"),
            @ApiImplicitParam(name = "realname", value = "用户姓名", required = true, paramType = "path", dataType = "String"),

    })
    @PostMapping("/")
    public PtResult<Boolean> add(LmsUserRelGroup lmsUserRelGroup) {
        return success(lmsUserRelGroupService.save(lmsUserRelGroup));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsUserRelGroupService.remove(Wrappers.<LmsUserRelGroup>query().in("id", ids)));
    }


    @ApiOperation(value = "用户编组设置组长", notes = "用户编组设置组长按钮")
    @PostMapping("/set_leader")
    public PtResult<Boolean> setLeader(@RequestParam("ids") Long[] ids, String leader) {
        return success(lmsUserRelGroupService.setLeader(ids, leader));
    }

    @ApiOperation(value = "根据组名查询用户编组", notes = "根据组名查询用户编组")
    @PostMapping("/list_user_by_groupId_and_userName")
    public PtResult<List<LmsUserRelGroup>> listUserByGroupIdAndUserName(@RequestBody LmsUserGroupDTO lmsUserGroupDTO) {
        return success(lmsUserRelGroupService.listUserByGroupIdAndUserName(lmsUserGroupDTO));
    }

    @ApiOperation(value = "根据组名查询用户编组", notes = "根据组名查询用户编组")
    @PostMapping("/list_by_user_id")
    public PtResult<List<LmsUserRelGroup>> listByUser(LmsUserRelGroup lmsUserRelGroup) {
        return success(lmsUserRelGroupService.list(lmsUserRelGroup));
    }

    @ApiOperation(value = "根据用户id查询用户编组", notes = "根据用户id查询用户编组")
    @PostMapping("/list_group_by_user_id")
    public PtResult<List<Long>> listGroupByUserId(@RequestBody Long userId) {
        return success(lmsUserRelGroupService.getAllGroupIdByUserId(userId));
    }

    @ApiOperation(value = "查询用户所在组的所有组员", notes = "查询用户所在组的所有组员")
    @PostMapping("/list_group_user_by_user_id")
    public PtResult<List<LmsUserRelGroup>> listGroupUserByUserId() {
        return success(lmsUserRelGroupService.listGroupUserByUserId(currentUserId()));
    }

    @PostMapping("/get_list_by_group_ids")
    public PtResult<List<LmsUserRelGroup>> getUserByGroupIds(@RequestParam("groupIds")Collection<Long> groupIds){
        return success(lmsUserRelGroupService.getUserByGroupIds(groupIds));
    }

    @PostMapping("/get_list_by_leader")
    public PtResult<List<LmsUserRelGroup>> getUserByleader(){
        return success(lmsUserRelGroupService.getUserByleader());
    }

    @ApiOperation(value = "根据组Id查询用户编组及组长", notes = "根据组Id查询用户编组及组长")
    @PostMapping("/get_list_by_group_leader")
    public PtResult<List<LmsUserRelGroup>> getUserByGroupIdByLeader(@RequestBody LmsUserGroupDTO lmsUserGroupDTO){
        return success(lmsUserRelGroupService.getListUserByGroupIdByLeader(lmsUserGroupDTO));
    }

    @ApiOperation(value = "根据组IdS查询用户编组", notes = "根据组Ids查询用户编组")
    @PostMapping("/get_list_by_group_ids_leader")
    public PtResult<List<LmsUserRelGroup>> getUserByGroupIdsLeader(@RequestParam("groupIds")Collection<Long> groupIds){
        return success(lmsUserRelGroupService.getUserByGroupIdsLeader(groupIds));
    }

    public PtResult<List<LmsUserRelGroup>> listGroupUsers(Long userId) {
        return null;
    }


}
