package com.patzn.lims.res.controller;

import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.res.service.MongoDbService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping("v1/oss")
public class MongoDbController  {

    @Autowired
    private MongoDbService mongoDbService;
    @Autowired
    private HttpServletRequest request;

    @Autowired
    private HttpServletResponse response;

    @GetMapping(value = "/downloadFile")
    public void downloadFile(@RequestParam("file_id") String fileId) {
        mongoDbService.downloadFile(fileId,request,response);
    }


    @PostMapping(value = "/upload")
    public void uploadFile(@RequestParam("businessId") String businessId, @RequestParam("file") MultipartFile file)  {
        mongoDbService.saveFile(file);
    }


    @GetMapping(value = "/preview")
    public void preview(@RequestParam("file_id") String fileId) {
         mongoDbService.preview(fileId,request,response);
    }


}
