package com.patzn.lims.res.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 温湿度数据信息表
 * </p>
 *
 * @author wangweidong
 * @since 2019-09-27
 */
//@Data
//@Accessors(chain = true)

@ApiModel
public class CollectThCustomerData extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "仪器ID")
	private Long equipId;

    @ApiModelProperty(value = "监测时间")
	private Long monitorTime;

    @ApiModelProperty(value = "温度")
	private BigDecimal temperature;

    @ApiModelProperty(value = "湿度")
	private BigDecimal humidity;

    @ApiModelProperty(value = "记录人")
	private String noteTaker;

    @ApiModelProperty(value = "记录人ID")
	private Long noteTakerId;

    @ApiModelProperty(value = "状态：0正常 1异常")
	private Integer status;

    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "告警类型")
	private String waringType;

	@ApiModelProperty(value = "告警")
	private String waring;

	@ApiModelProperty(value = "位置")
	private String place;

	public Long getEquipId() {
		return equipId;
	}

	public void setEquipId(Long equipId) {
		this.equipId = equipId;
	}

	public Long getMonitorTime() {
		return monitorTime;
	}

	public void setMonitorTime(Long monitorTime) {
		this.monitorTime = monitorTime;
	}

	public BigDecimal getTemperature() {
		return temperature;
	}

	public void setTemperature(BigDecimal temperature) {
		this.temperature = temperature;
	}

	public BigDecimal getHumidity() {
		return humidity;
	}

	public void setHumidity(BigDecimal humidity) {
		this.humidity = humidity;
	}

	public String getNoteTaker() {
		return noteTaker;
	}

	public void setNoteTaker(String noteTaker) {
		this.noteTaker = noteTaker;
	}

	public Long getNoteTakerId() {
		return noteTakerId;
	}

	public void setNoteTakerId(Long noteTakerId) {
		this.noteTakerId = noteTakerId;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Long getCompanyId() {
		return companyId;
	}

	public void setCompanyId(Long companyId) {
		this.companyId = companyId;
	}

	public Integer getDeleted() {
		return deleted;
	}

	public void setDeleted(Integer deleted) {
		this.deleted = deleted;
	}

	public Long getUid() {
		return uid;
	}

	public void setUid(Long uid) {
		this.uid = uid;
	}

	public Date getCtime() {
		return ctime;
	}

	public void setCtime(Date ctime) {
		this.ctime = ctime;
	}

	public Long getLid() {
		return lid;
	}

	public void setLid(Long lid) {
		this.lid = lid;
	}

	public Date getLtime() {
		return ltime;
	}

	public void setLtime(Date ltime) {
		this.ltime = ltime;
	}

	public String getWaringType() {
		return waringType;
	}

	public void setWaringType(String waringType) {
		this.waringType = waringType;
	}

	public String getWaring() {
		return waring;
	}

	public void setWaring(String waring) {
		this.waring = waring;
	}

	public String getPlace() {
		return place;
	}

	public void setPlace(String place) {
		this.place = place;
	}
}
