package com.patzn.lims.res.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 自定义表单参数
 *
 * @author hubin
 */
@Data
public class LmsFormDto {
    @NotNull(message = "主键ID不能为空")
    @ApiModelProperty(value = "主键ID")
    private Long id;

    @NotBlank(message = "标题不能为空")
    @ApiModelProperty(value = "标题")
    private String title;

    @NotBlank(message = "JSON内容不能为空")
    @ApiModelProperty(value = "JSON")
    private String json;

}
