package com.patzn.lims.res.dto;

import com.patzn.lims.res.entity.LmsSignatureInfo;
import com.patzn.lims.res.enums.SignatureClassifyEnum;
import com.patzn.lims.res.vo.LmsSignatureInfoVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author zhaokai
 * @since 2019-03-16
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsSignatureInfoDTO extends LmsSignatureInfo {

    @ApiModelProperty("印章的list")
    private ArrayList<LmsSignatureInfoVO> infoList;

    @ApiModelProperty("食品报告id的数组")
    private Long[] ids;

    @ApiModelProperty("环境报告id的数组")
    private Long[] envReportIds;

    @ApiModelProperty("环境委托id的数组")
    private Long[] envContractIds;

    @ApiModelProperty("环境委托状态")
    private String envContractStatus;

    @ApiModelProperty("消息序列号")
    private String seriesNo;

    @ApiModelProperty("是否插入二维码")
    private Integer qrcodeIn;

    public List<LmsSignatureInfoVO> getByClassify(SignatureClassifyEnum classifyEnum) {
        if (CollectionUtils.isEmpty(infoList) || null == classifyEnum) {
            return null;
        }
        List<LmsSignatureInfoVO> list = new ArrayList<>();
        for (LmsSignatureInfoVO info : infoList) {
            if (Objects.equals(classifyEnum, info.getClassify())) {
                list.add(info);
            }
        }
        return list;
    }

    public LmsSignatureInfoVO getQrcode() {
        if (CollectionUtils.isEmpty(infoList)) {
            return null;
        }
        for (LmsSignatureInfoVO info : infoList) {
            if (Objects.equals("二维码", info.getName())) {
                return info;
            }
        }
        return null;
    }
}
