package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.Objects;

/**
 * <p>
 * 字典表
 * </p>
 *
 * @author patzn
 * @since 2017-09-07
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsBaseDict extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "父 ID")
	private Long pid;

    @ApiModelProperty(value = "名称")
	private String name;

    @ApiModelProperty(value = "关键字")
	private String key;

    @ApiModelProperty(value = "编码值")
	private String code;

    @ApiModelProperty(value = "标签名")
	private String label;

    @ApiModelProperty(value = "分类")
	private String type;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "状态（0、禁用 1、正常）")
	private Integer status;

    @ApiModelProperty(value = "排序")
	private Integer sort;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	public LmsBaseDict() {
		super();
	}

	public LmsBaseDict(String name, String key, String code) {
		this.name = name;
		this.key = key;
		this.code = code;
	}

	//快速初始化用
	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		LmsBaseDict lbd = (LmsBaseDict) o;
		return Objects.equals(name, lbd.name)
				&& Objects.equals(type,lbd.type);
	}

}
