package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 车辆使用记录表
 * </p>
 *
 * @author patzn
 * @since 2018-03-26
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsCarRecord extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "车辆ID")
	private Long carId;

    @ApiModelProperty(value = "使用日期")
	private Date useDate;

    @ApiModelProperty(value = "归还日期")
	private Date returnDate;

    @ApiModelProperty(value = "出发前公里数")
	private BigDecimal berforeMileage;

    @ApiModelProperty(value = "出发后公里数")
	private BigDecimal afterMileage;

    @ApiModelProperty(value = "使用人ID")
	private Long userId;

    @ApiModelProperty(value = "使用人")
	private String usePerson;

    @ApiModelProperty(value = "使用用途")
	private String purpose;

    @ApiModelProperty(value = "创建人")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "公司ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "删除 0、否 1、是")
    @TableLogic
	private Integer deleted;


}
