package com.patzn.lims.res.entity;

import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author zhaokai
 * @since 2019-07-10
 */
@Data
@Accessors(chain = true)
public class LmsCodeEntity extends BaseEntity {

    @ApiModelProperty("委托编号")
    private String code;

    @ApiModelProperty("样品编号")
    private String num;

    @ApiModelProperty(value = "合同名称")
    private String name;

    @ApiModelProperty(value = "检测类型")
    private String detectType;

    @ApiModelProperty(value = "合同来源")
    private String originate;

    @ApiModelProperty(value = "是否采样")
    private Integer sampling;

    @ApiModelProperty(value = "服务类型")
    private String service;

    @ApiModelProperty(value = "样品加密编号")
    private String labNum;

    @ApiModelProperty(value = "监测类型")
    private String testType;

    @ApiModelProperty(value = "采样日期(年月日)")
    private Date samplingDate;

    @ApiModelProperty(value = "点位")
    private String point;

    @ApiModelProperty(value = "点位编号")
    private String pointCode;

    @ApiModelProperty(value = "所属天数")
    private Integer belongDay;

    @ApiModelProperty(value = "所属频次")
    private Integer belongFrequency;

    @ApiModelProperty(value = "样品名称")
    private String sampleName;
}
