package com.patzn.lims.res.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;

import com.patzn.lims.res.enums.CodeTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 编号规则
 * </p>
 *
 * @author patzn
 * @since 2018-04-11
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsCodeRule extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "前缀")
    private String pre;

    @ApiModelProperty(value = "序列号")
    private Integer sn;

    @ApiModelProperty(value = "规则")
    private String rule;

    @ApiModelProperty(value = "类型")
    private CodeTypeEnum type;

    @ApiModelProperty(value = "允许重复 0、否 1、是")
    private Integer repeat;

    @ApiModelProperty(value = "长度")
    private Integer length;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;

    @ApiModelProperty(value = "编号截取长度")
    private Integer sublength;



    @ApiModelProperty(value = "是否延续编号")
    private Integer continueSn;



    @ApiModelProperty(value = "编号顺延忽略的字符(多个以逗号区分)")
    private String ignoreNum;


    public String getRule() {
        // 去除空格
        return null == rule ? null : rule.trim();
    }

    public void setRule(String rule) {
        this.rule = rule;
    }
}
