package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 编号规则记录
 * </p>
 *
 * @author patzn
 * @since 2018-06-06
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsCodeRuleRecord extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "编号规则 ID")
	private Long codeRuleId;

    @ApiModelProperty(value = "变化部分")
	private String vary;

    @ApiModelProperty(value = "序列号")
	private Integer sn;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;


}
