package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.res.enums.ColumnQuestionBelongEnum;
import com.patzn.lims.res.enums.ColumnQuestionTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 扩展字段问题表
 * </p>
 *
 * @author patzn
 * @since 2018-05-24
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsColumnQuestion extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "扩展字段属于 0、食品合同表")
    private ColumnQuestionBelongEnum belong;

    @ApiModelProperty(value = "0、填空 1、单选 2、多选")
    private ColumnQuestionTypeEnum type;

    @ApiModelProperty(value = "0、非必填 1、必填")
    private Integer require;

    @ApiModelProperty(value = "字段")
    private String column;

    @ApiModelProperty(value = "显示")
    private String display;

    @ApiModelProperty(value = "排序")
    private Integer sort;


}
