package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.core.type.TypeReference;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.core.toolkit.JacksonUtils;
import com.patzn.lims.res.enums.ComponentFlowTypeEnum;
import com.patzn.lims.res.flow.ComponentFlow;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 业务组件流表
 * </p>
 *
 * @author patzn
 * @since 2018-05-17
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsComponentFlow extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "业务类型")
    private ComponentFlowTypeEnum type;

    @ApiModelProperty(value = "规则")
    private String rule;

    @ApiModelProperty(value = "创建人 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "修改人 ID")
    @TableField(fill = FieldFill.UPDATE)
    private Long lid;

    @ApiModelProperty(value = "修改时间")
    @TableField(fill = FieldFill.UPDATE)
    private Date ltime;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;

    public String getRuleStr() {
        if (StringUtils.isEmpty(rule)) {
            return "/";
        }

        // 解析 JSON 为业务流
        List<ComponentFlow> cfList = JacksonUtils.readValue(this.getRule(), new TypeReference<List<ComponentFlow>>() {
        });
        if (CollectionUtils.isEmpty(cfList)) {
            return "/";
        }



        return rule;
    }
}
