package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 客户信息表
 * </p>
 *
 * @author patzn
 * @since 2017-09-15
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsCustomer extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "中文名称")
	@TableField(condition = SqlCondition.LIKE)
	private String cname;

    @ApiModelProperty(value = "英文名称")
	@TableField(condition = SqlCondition.LIKE)
	private String ename;

    @ApiModelProperty(value = "分类")
	private Integer type;

    @ApiModelProperty(value = "主联系人")
	private String contact;

    @ApiModelProperty(value = "联系手机")
	private String mobile;

    @ApiModelProperty(value = "客户等级")
	private Integer rank;

    @ApiModelProperty(value = "信用等级")
	private String credit;

    @ApiModelProperty(value = "税务")
	private String taxation;

    @ApiModelProperty(value = "公司地址")
	private String companyAddress;

    @ApiModelProperty(value = "开户银行")
	private String bank;

    @ApiModelProperty(value = "银行账户")
	private String bankAccount;

    @ApiModelProperty(value = "状态（0、禁用 1、正常）")
	private Integer status;

    @ApiModelProperty(value = "0、正常 1、删除")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "最后修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "开票电话")
	private String billTell;

}
