package com.patzn.lims.res.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author patzn
 * @since 2018-08-08
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsCustomerContact extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "供应商 ID")
	private Long customerId;

    @ApiModelProperty(value = "电话")
	private String phone;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "姓名")
	private String name;

    @ApiModelProperty(value = "职位")
	private String position;

    @ApiModelProperty(value = "是否删除")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;


}
