package com.patzn.lims.res.entity;

import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 客户信息详情表
 * </p>
 *
 * @author patzn
 * @since 2017-09-15
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsCustomerDetail extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "供应商 ID")
	private Long customerId;

    @ApiModelProperty(value = "固定电话")
	private String phone;

    @ApiModelProperty(value = "传真")
	private String fax;

    @ApiModelProperty(value = "邮箱")
	private String email;

    @ApiModelProperty(value = "邮编")
	private String postcode;

    @ApiModelProperty(value = "省份")
	private String province;

    @ApiModelProperty(value = "城市")
	private String city;

    @ApiModelProperty(value = "地区")
	private String area;

    @ApiModelProperty(value = "联系街道")
	private String street;

    @ApiModelProperty(value = "联系地址")
	private String address;

    @ApiModelProperty(value = "网站")
	private String website;

    @ApiModelProperty(value = "来源")
	private String origin;

    @ApiModelProperty(value = "邮寄方式")
	private Integer postWay;

    @ApiModelProperty(value = "邮寄地址")
	private String postAddress;

    @ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "经度")
	private String longitude;

	@ApiModelProperty(value = "纬度")
	private String latitude;

	@ApiModelProperty(value = "主营业务")
	private String business;




}
