package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 报销信息
 * </p>
 *
 * @author zhaokai
 * @since 2019-08-01
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsExpensesInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "是否删除")
    @TableLogic
    private Integer deleted;

    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty(value = "状态的显示")
    private String progress;

    @ApiModelProperty(value = "报销类型")
    private String reimbursementType;

    @ApiModelProperty(value = "项目编号")
    private String code;

    @ApiModelProperty(value = "报销事由")
    private String reason;

    @ApiModelProperty(value = "审批意见")
    private String reviewOpinion;

    @ApiModelProperty(value = "审核人ID")
    private Long reviewerId;

    @ApiModelProperty(value = "审核人")
    private String reviewer;

    @ApiModelProperty(value = "审核时间")
    private Date reviewDate;

    @ApiModelProperty(value = "发放人ID")
    private Long senderId;

    @ApiModelProperty(value = "发放人")
    private String sender;

    @ApiModelProperty(value = "发放时间")
    private Date sendDate;

    @ApiModelProperty(value = "创建人")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;

    @ApiModelProperty(value = "最后修改人ID")
    @TableField(fill = FieldFill.UPDATE)
    private Long lid;

    @ApiModelProperty(value = "最后修改时间")
    @TableField(fill = FieldFill.UPDATE)
    private Date ltime;

    @ApiModelProperty(value = "申请日期")
    private Date applyDate;

    @ApiModelProperty(value = "报销人")
    private String reimburser;

    @ApiModelProperty(value = "报销人ID")
    private Long reimburserId;


}
