package com.patzn.lims.res.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author zhaokai
 * @since 2019-08-01
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsExpensesList extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "报销信息id")
    private Long expensesId;

    @ApiModelProperty(value = "企业ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "是否删除")
    @TableLogic
    private Integer deleted;

    @ApiModelProperty(value = "借款日期")
    private Date borrowDate;

    @ApiModelProperty(value = "还款日期")
    private Date returnDate;

    @ApiModelProperty(value = "金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "支付方式")
    private String paymentType;

    @ApiModelProperty(value = "收款单位")
    private String receiverName;

    @ApiModelProperty(value = "银行账号")
    private String bankNo;

    @ApiModelProperty(value = "开户行")
    private String bank;

    @ApiModelProperty(value = "车辆号码")
    private String carNo;

    @ApiModelProperty(value = "产权人")
    private String propertyOwner;

    @ApiModelProperty(value = "发票号码")
    private String invoiceNo;

    @ApiModelProperty(value = "品名")
    private String sampleName;

    @ApiModelProperty(value = "数量")
    private Integer num;

    @ApiModelProperty(value = "出发地")
    private String departure;

    @ApiModelProperty(value = "目的地")
    private String destination;

    @ApiModelProperty(value = "交通费")
    private BigDecimal transportationFee;

    @ApiModelProperty(value = "住宿费")
    private BigDecimal accommodationFee;

    @ApiModelProperty(value = "补贴费")
    private BigDecimal subsidyFee;

    @ApiModelProperty(value = "其他费用")
    private BigDecimal otherFee;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人ID")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;

    @ApiModelProperty(value = "最后修改人ID")
    @TableField(fill = FieldFill.UPDATE)
    private Long lid;

    @ApiModelProperty(value = "最后修改时间")
    @TableField(fill = FieldFill.UPDATE)
    private Date ltime;

    @ApiModelProperty(value = "日期")
    private Date expensesDate;


}
