package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 模板文件表
 * </p>
 *
 * @author yc
 * @since 2019-01-08
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFileTemplate extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "别名")
    private String alias;

    @ApiModelProperty(value = "桶名称")
    private String bucketName;

    @ApiModelProperty(value = "对象key")
    private String objectKey;

    @ApiModelProperty(value = "版本")
    private String versionId;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "用户 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;

    @ApiModelProperty(value = "分类 ID")
    private Long classifyId;

    @ApiModelProperty(value = "最后修改人")
    @TableField(fill = FieldFill.UPDATE)
    private Long lid;

    @ApiModelProperty(value = "最后修改时间")
    @TableField(fill = FieldFill.UPDATE)
    private Date ltime;

    @ApiModelProperty(value = "服务名")
    private String service;

    @ApiModelProperty(value = "备注")
    private String remark;


}
