package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 模板文件分类表
 * </p>
 *
 * @author yc
 * @since 2019-01-08
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsFileTemplateClassify extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "父 ID")
    private Long pid;

    @ApiModelProperty(value = "企业 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "用户 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "服务名")
    private String service;


}
