package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 自定义表单表
 * </p>
 *
 * @author patzn
 * @since 2020-04-15
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsForm extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty(value = "json 内容")
    private String json;

    @ApiModelProperty(value = "操作人 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "操作人")
    @TableField(fill = FieldFill.INSERT)
    private String operator;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;

    @ApiModelProperty(value = "状态")
    private Integer status;

}
