package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.res.enums.LabelTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 标签配置库
 * </p>
 *
 * @author zhaokai
 * @since 2019-08-26
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsLabel extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "是否删除")
    @TableLogic
    private Integer deleted;

    @ApiModelProperty(value = "标签类型")
    private LabelTypeEnum type;

    @ApiModelProperty(value = "标签代码")
    private String code;

    @ApiModelProperty(value = "创建人id")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "创建人")
    private String uname;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;

    @ApiModelProperty(value = "最后修改人id")
    @TableField(fill = FieldFill.UPDATE)
    private Long lid;

    @ApiModelProperty(value = "最后修改人")
    private String lname;

    @ApiModelProperty(value = "最后修改时间")
    @TableField(fill = FieldFill.UPDATE)
    private Date ltime;


}
