package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 供应商产品表
 * </p>
 *
 * @author patzn
 * @since 2018-06-23
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsProduct extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "产品类别")
	@TableField(condition = SqlCondition.LIKE)
	private String category;

    @ApiModelProperty(value = "产品类别id")
	private Long categoryId;

    @ApiModelProperty(value = "产品名称")
	@TableField(condition = SqlCondition.LIKE)
	private String name;

    @ApiModelProperty(value = "密度")
	private String thickness;

    @ApiModelProperty(value = "不确定度")
	private String unsure;

    @ApiModelProperty(value = "制造厂商")
	@TableField(condition = SqlCondition.LIKE)
	private String manufacturer;

    @ApiModelProperty(value = "纯度")
	private String quality;

    @ApiModelProperty(value = "标准值")
	private String standard;

    @ApiModelProperty(value = "规格")
	private String spec;

    @ApiModelProperty(value = "计量单位")
	private String unit;

    @ApiModelProperty(value = "品牌")
	private String brand;

    @ApiModelProperty(value = "使用范围")
	private String useScop;

    @ApiModelProperty(value = "企业id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "是否删除")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "首字母拼音")
	private String pinyin;

    @ApiModelProperty(value = "备注")
	private String remark;


}
