package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 产品类别表
 * </p>
 *
 * @author patzn
 * @since 2018-06-23
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsProductCategory extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "父id")
	private Long pid;

    @ApiModelProperty(value = "企业id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "名称")
	@TableField(condition = SqlCondition.LIKE)
	private String name;

    @ApiModelProperty(value = "状态")
	private Integer status;

    @ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "编码")
	private Long num;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "首字母拼音")
	private String pinyin;

    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;


}
