package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author patzn
 * @since 2018-06-21
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsProperty extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "名称")
	private String name;

    @ApiModelProperty(value = "关键字")
	private String key;

    @ApiModelProperty(value = "编码值")
	private String code;

    @ApiModelProperty(value = "标签名")
	private String label;

    @ApiModelProperty(value = "分类")
	private String type;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "状态（0、禁用 1、正常）")
	private Integer status;

    @ApiModelProperty(value = "排序")
	private Integer sort;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;


    @ApiModelProperty(value = "父id")
	private Long pid;


}
