package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author patzn
 * @since 2018-05-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsServiceType extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "服务类型")
	private String name;

    @ApiModelProperty(value = "最大工作日")
	private Integer days;

    @ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "企业id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

	@ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
}
