package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.res.enums.SignatureClassifyEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 签章表
 * </p>
 *
 * @author ldx
 * @since 2018-09-29
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsSignatureInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "是否删除")
    @TableLogic
    private Integer deleted;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "文件类型")
    private String type;

    @ApiModelProperty(value = "桶名称")
    private String bucketName;

    @ApiModelProperty(value = "对象key")
    private String objectKey;

    @ApiModelProperty(value = "版本")
    private String versionId;

    @ApiModelProperty(value = "用户 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;

    @ApiModelProperty(value = "签章类别")
    private SignatureClassifyEnum classify;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "配置")
    private String config;

    @ApiModelProperty(value = "左偏移")
    private BigDecimal leftOffset;

    @ApiModelProperty(value = "上偏移")
    private BigDecimal topOffset;

    @ApiModelProperty(value = "是否默认")
    private Integer defaultSign;

}
