package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 仓库表
 * </p>
 *
 * @author patzn
 * @since 2017-11-27
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsStorehouse extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "父 ID")
	private Long pid;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "创建者 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "名称")
	@TableField(condition = SqlCondition.LIKE)
	private String name;

	@ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "最后修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;


}
