package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 供应商表
 * </p>
 *
 * @author patzn
 * @since 2017-09-15
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsSupplier extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "操作人")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @TableField(condition = SqlCondition.LIKE)
    @ApiModelProperty(value = "名称")
	private String name;

    @ApiModelProperty(value = "分类 ID")
	private Long typeId;

    @ApiModelProperty(value = "主联系人")
	private String contact;

    @ApiModelProperty(value = "联系手机")
	private String mobile;

    @ApiModelProperty(value = "客户等级")
	private String rank;

    @ApiModelProperty(value = "信用等级")
	private String credit;

    @ApiModelProperty(value = "状态（0、禁用 1、正常）")
	private Integer status;

    @ApiModelProperty(value = "0、正常 1、删除")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "税务")
	private String taxation;

	@ApiModelProperty(value = "最后修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

	@ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;


	@ApiModelProperty(value = "开户银行")
	private String bank;

	@ApiModelProperty(value = "银行账户")
	private String bankAccount;

	@ApiModelProperty(value = "供应类型")
	private String supplyScope;

	@ApiModelProperty(value = "首次列入日期")
	private Date firstDate;

	@ApiModelProperty(value = "评价表编号")
	private String evaluateCode;

	@ApiModelProperty(value = "评价人员")
	private String evaluatePerson;

	@ApiModelProperty(value = "登记人员")
	private String uname;

	@ApiModelProperty(value = "开票电话")
	private String billTel;


	@ApiModelProperty(value = "审厂分数")
	private String score;

	@ApiModelProperty(value = "供应范围")
	private String serviceArea;



}
