package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 供应商附件表
 * </p>
 *
 * @author patzn
 * @since 2018-06-22
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsSupplierAttachment extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "公司 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "供应商 ID")
	private Long supplierId;

    @ApiModelProperty(value = "文件名")
	private String fileName;

    @ApiModelProperty(value = "桶名称")
	private String bucketName;

    @ApiModelProperty(value = "对象 key")
	private String objectKey;

    @ApiModelProperty(value = "版本号")
	private String versionId;

    @ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "文件类型")
	private String type;


}
