package com.patzn.lims.res.entity;

import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 供应商详情表
 * </p>
 *
 * @author patzn
 * @since 2017-09-15
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsSupplierDetail extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "供应商 ID")
	private Long supplierId;

    @ApiModelProperty(value = "固定电话")
	private String phone;

    @ApiModelProperty(value = "传真")
	private String fax;

    @ApiModelProperty(value = "联系街道")
	private String address;

    @ApiModelProperty(value = "邮箱")
	private String email;

    @ApiModelProperty(value = "邮编")
	private String postcode;

    @ApiModelProperty(value = "网站")
	private String website;

    @ApiModelProperty(value = "法人")
	private String legalPerson;

    @ApiModelProperty(value = "法人联系电话")
	private String legalPhone;

    @ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "省")
	private String province;

	@ApiModelProperty(value = "市")
	private String city;

	@ApiModelProperty(value = "县")
	private String county;

	@ApiModelProperty(value = "审厂分数")
	private String score;


}
