package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 供应商关联产品表
 * </p>
 *
 * @author patzn
 * @since 2018-06-23
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsSupplierRelProduct extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "供应商id")
	private Long supplierId;

    @ApiModelProperty(value = "产品id")
	private Long productId;

    @ApiModelProperty(value = "报价")
	private BigDecimal price;

    @ApiModelProperty(value = "企业id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "备注")
	private String remark;


}
