package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 供应商表
 * </p>
 *
 * @author patzn
 * @since 2017-12-27
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsSupplierType extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "操作人")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "名称")
	@TableField(condition = SqlCondition.LIKE)
	private String name;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;


}
