package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 类别模板管理表
 * </p>
 *
 * @author zhaokai
 * @since 2018-11-06
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsTypeReportTemplate extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "名称")
	private String name;

    @ApiModelProperty(value = "别名", required = true)
	private String alias;

    @ApiModelProperty(value = "桶名称")
	private String bucketName;

    @ApiModelProperty(value = "对象key")
	private String objectKey;

    @ApiModelProperty(value = "版本")
	private String versionId;

    @ApiModelProperty(value = "类型")
	private String type;

    @ApiModelProperty(value = "用户 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "分类 ID")
	private Long classifyId;

    @ApiModelProperty(value = "样品的检测类别", required = true)
	private String testType;

	@ApiModelProperty(value = "排序号", required = true)
	private Integer order;

}
