package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 单位表
 * </p>
 *
 * @author patzn
 * @since 2017-11-29
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsUnit extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "名称")
	private String name;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "排序")
	private Integer sort;

    @ApiModelProperty(value = "最后修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;


}
