package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 用户组表
 * </p>
 *
 * @author patzn
 * @since 2018-03-28
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsUserGroup extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "组名")
	private String name;

    @ApiModelProperty(value = "组描述")
	private String decp;

    @ApiModelProperty(value = "公司 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "最后修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "删除 0、否 1、是")
    @TableLogic
	private Integer deleted;

	@ApiModelProperty(value = "科室分类")
	private String type;

	@ApiModelProperty(value = "英文名缩写")
	private String shortName;

	@ApiModelProperty(value = "排序")
	private Integer sort;
}
