package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 用户关联组表
 * </p>
 *
 * @author patzn
 * @since 2018-03-28
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsUserRelGroup extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户 ID")
	private Long userId;

	@ApiModelProperty(value = "用户组 ID")
	private Long groupId;

    @ApiModelProperty(value = "用户名称")
	private String realname;

    @ApiModelProperty(value = "公司 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "最后修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

	@ApiModelProperty(value = "是否是组长")
	private Integer leader;

	@ApiModelProperty(value = "用户名")
	private String username;
}
