package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 仪器分类信息表
 * </p>
 *
 * @author zhaokai
 * @since 2018-10-18
 */
@Data
@Accessors(chain = true)
@ApiModel
public class ReportClass extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "类别名")
	private String name;

    @ApiModelProperty(value = "父id")
	private Long pid;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "企业id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
}
