package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 报表导出表
 * </p>
 *
 * @author hubin
 * @since 2018-12-19
 */
@Data
@Accessors(chain = true)
@ApiModel
public class ReportExport extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "报表 ID")
	private Long reportId;

	@ApiModelProperty(value = "按钮名称")
	private String buttonName;

    @ApiModelProperty(value = "关键字")
	private String key;

    @ApiModelProperty(value = "服务名")
	private String service;

    @ApiModelProperty(value = "自定义地址")
	private String uri;

	/**
	 * 支持 excel sheet word pdf preview
	 */
	@ApiModelProperty(value = "导出方式")
	private String mode;

	@ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "操作人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "操作人")
	@TableField(fill = FieldFill.INSERT)
	private String operator;

    @ApiModelProperty(value = "修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;


}
