package com.patzn.lims.res.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 报表 XML 表
 * </p>
 *
 * @author hubin
 * @since 2018-12-04
 */
@Data
@Accessors(chain = true)
@ApiModel
public class ReportXml extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "文件名称")
	private String name;

    @ApiModelProperty(value = "XML")
	private String xml;

	@ApiModelProperty(value = "服务名")
	@TableField(condition = SqlCondition.LIKE)
	private String service;

    @ApiModelProperty(value = "操作人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "操作人")
	@TableField(fill = FieldFill.INSERT)
	private String operator;

    @ApiModelProperty(value = "修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

    @ApiModelProperty(value = "修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;


}
