package com.patzn.lims.res.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 编号类型枚举
 * </p>
 *
 * @author hubin
 * @since 2018-04-11
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum CarStatusEnum implements IBaseEnum {
    NORMAL(0, "正常"),
    STOP_USE(1, "停用");

    private int value;
    private String display;

    CarStatusEnum(final int value, final String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDisplay() {
        return this.display;
    }
}