package com.patzn.lims.res.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 编号类型枚举
 * </p>
 *
 * @author hubin
 * @since 2018-04-11
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum CodeTypeEnum implements IBaseEnum {
    /**
     * 编号类型
     */
    DRUG_SAMPLE(0, "食药样品编号"),
    ENV_SAMPLE(10, "环境样品编号"),
    DRUG_REPORT(20, "食药报告编号"),




    CHEMICAL_PURCHASE(110,"耗材采购单编号"),

    CHEMICAL_APPLY(130,"耗材申请单编号"),


    EQUIP(215, "仪器编号"),
    EQUIP_PURCHASE(201,"仪器采购编号"),
    EQUIP_OUT_STOCK(202,"仪器出库编号"),

    ;

    private int value;
    private String display;

    CodeTypeEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }
}