package com.patzn.lims.res.enums;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 扩展字段所属类型枚举
 * </p>
 *
 * @author hubin
 * @since 2018-05-24
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum ColumnQuestionBelongEnum implements IBaseEnum {
    FOOD_CONTRACT(0, "食品合同"),
    FOOD_SAMPLE(1, "食品样品");

    private int value;
    private String display;

    ColumnQuestionBelongEnum(final int value, final String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDisplay() {
        return this.display;
    }
}