package com.patzn.lims.res.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 扩展字段所属类型枚举
 * </p>
 *
 * @author hubin
 * @since 2018-05-24
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum ColumnQuestionTypeEnum implements IBaseEnum {
    INNPUT(0, "填空"),
    RADIO(1, "单选"),
    CHECKBOX(2, "多选");

    private int value;
    private String display;

    ColumnQuestionTypeEnum(final int value, final String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDisplay() {
        return this.display;
    }
}