package com.patzn.lims.res.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.common.CommonConstants;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 业务流程状态枚举
 * </p>
 *
 * @author hubin
 * @since 2018-05-17
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum ComponentFlowStatusEnum implements IBaseEnum {
    CLAIM(-1, "认领"),
    INIT(0, "初始"),
    PASS(1, "通过"),
    BACK(2, "驳回");

    private int value;
    private String display;

    ComponentFlowStatusEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }

    public static String display(IBaseEnum baseEnum, String[] textArr) {
        if (null != baseEnum && null != textArr) {
            StringBuilder display = new StringBuilder(baseEnum.getDisplay());
            if (textArr.length > 1 && textArr[1].equals(String.valueOf(ComponentFlowStatusEnum.BACK.getValue()))) {
                display.append("退回");
            }
            return display.toString();
        }
        return CommonConstants.SYMBOL_GANG;
    }
}