package com.patzn.lims.res.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>
 * 业务流程类型枚举
 * </p>
 *
 * @author hubin
 * @since 2018-05-17
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum ComponentFlowTypeEnum implements IBaseEnum {
    FOOD_TEST(0, "食品检测"),
    ENV_TEST(10, "环境合同"),
    ENV_TEST_ITEM(11, "参数"),
    ENV_SIMPLE_TEST(15, "环境合同简版"),
    ;


    private int value;
    private String display;

    ComponentFlowTypeEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }

    public static ComponentFlowTypeEnum get(int value) {
        ComponentFlowTypeEnum[] values = values();
        for (ComponentFlowTypeEnum typeEnum : values) {
            if (Objects.equals(typeEnum.getValue(), value)) {
                return typeEnum;
            }
        }
        return null;
    }
}